/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy.animation;

import de.keksuccino.fancymenu.customization.layout.editor.buddy.Buddy;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.animation.AnimationState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationStates {
    private static final Map<String, AnimationState> STATE_MAP = new HashMap<String, AnimationState>();
    private static final int ATLAS_INDEX_IDLE_WALK = 0;
    private static final int ATLAS_INDEX_BEING_PET = 1;
    private static final int ATLAS_INDEX_SAD_WALK = 2;
    private static final int ATLAS_INDEX_EATING_STAND = 3;
    private static final int ATLAS_INDEX_PLAYING_WITH_BALL_STAND = 4;
    private static final int ATLAS_INDEX_SLEEPING = 5;
    private static final int ATLAS_INDEX_IDLE_STAND = 6;
    private static final int ATLAS_INDEX_SAD_STAND = 7;
    private static final int ATLAS_INDEX_STRETCHING_STANDING = 8;
    private static final int ATLAS_INDEX_EXCITED_WALKING = 9;
    private static final int ATLAS_INDEX_POOPING_STANDING = 10;
    private static final int ATLAS_INDEX_LOOKING_AROUND_STANDING = 11;
    private static final int ATLAS_INDEX_GRUMPY_STAND = 12;
    private static final int ATLAS_INDEX_SLEEPY_WALKING = 13;
    private static final int ATLAS_INDEX_SITTING = 14;
    private static final int ATLAS_INDEX_WAVING = 15;
    private static final int ATLAS_INDEX_YAWNING = 16;
    private static final int ATLAS_INDEX_PEEKING = 17;
    public static final AnimationState PEEKING = AnimationStates.registerState(new AnimationState.Builder("PEEKING", 17).priority(110).allowsMovement(false).allowsHopping(false).animationSpeed((buddy, state) -> 50).activationCondition(buddy -> buddy.isPeeking && buddy.isActivelyPeeking).preventionCondition(buddy -> !buddy.hasBeenAwakened ? false : buddy.needsFood || buddy.needsPet || buddy.needsPlay || buddy.isSleepy).ignoresLockedState(true).build());
    public static final AnimationState POOPING_STANDING = AnimationStates.registerState(new AnimationState.Builder("POOPING_STANDING", 10).priority(100).allowsMovement(false).allowsHopping(false).activationCondition(buddy -> buddy.isPooping).temporaryState(true).duration(60, 60).ignoresLockedState(true).build());
    public static final AnimationState SLEEPING = AnimationStates.registerState(new AnimationState.Builder("SLEEPING", 5).priority(90).allowsMovement(false).allowsHopping(false).animationSpeed((buddy, state) -> 15).activationCondition(buddy -> buddy.isSleeping).ignoresLockedState(true).build());
    public static final AnimationState GRUMPY_STANDING = AnimationStates.registerState(new AnimationState.Builder("GRUMPY_STANDING", 12).priority(80).allowsMovement(false).allowsHopping(false).activationCondition(buddy -> buddy.isGrumpy).temporaryState(true).duration(60, 60).build());
    public static final AnimationState EATING_STANDING = AnimationStates.registerState(new AnimationState.Builder("EATING_STANDING", 3).priority(70).allowsMovement(false).allowsHopping(false).activationCondition(buddy -> buddy.isEating).temporaryState(true).duration(60, 60).ignoresLockedState(true).build());
    public static final AnimationState BEING_PET = AnimationStates.registerState(new AnimationState.Builder("BEING_PET", 1).priority(70).allowsMovement(false).allowsHopping(false).activationCondition(buddy -> buddy.isBeingPet).temporaryState(true).duration(40, 40).ignoresLockedState(true).build());
    public static final AnimationState PLAYING_WITH_BALL_STANDING = AnimationStates.registerState(new AnimationState.Builder("PLAYING_WITH_BALL_STANDING", 4).priority(60).allowsMovement(false).allowsHopping(false).activationCondition(buddy -> buddy.isPlaying && buddy.isHoldingBall).ignoresLockedState(true).build());
    public static final AnimationState CHASING_BALL = AnimationStates.registerState(new AnimationState.Builder("CHASING_BALL", 0).priority(59).walkingSpeed((buddy, state) -> 5).activationCondition(buddy -> buddy.isChasingBall).ignoresLockedState(true).build());
    public static final AnimationState YAWNING_STANDING = AnimationStates.registerState(new AnimationState.Builder("YAWNING_STANDING", 16).priority(40).allowsMovement(false).allowsHopping(false).animationSpeed((buddy, state) -> 25).activationCondition(buddy -> buddy.isYawning).temporaryState(true).duration(50, 70).build());
    public static final AnimationState WAVING_STANDING = AnimationStates.registerState(new AnimationState.Builder("WAVING_STANDING", 15).priority(55).allowsMovement(false).allowsHopping(false).animationSpeed((buddy, state) -> 5).activationCondition(buddy -> buddy.isWaving).preventionCondition(buddy -> buddy.isSad() || buddy.isSleepy).temporaryState(true).duration(40, 60).build());
    public static final AnimationState SITTING = AnimationStates.registerState(new AnimationState.Builder("SITTING", 14).priority(30).allowsMovement(false).allowsHopping(false).animationSpeed((buddy, state) -> 10).activationCondition(buddy -> buddy.isSitting).temporaryState(true).duration(80, 240).build());
    public static final AnimationState LOOKING_AROUND_STANDING = AnimationStates.registerState(new AnimationState.Builder("LOOKING_AROUND_STANDING", 11).priority(29).allowsMovement(false).allowsHopping(false).animationSpeed((buddy, state) -> 80).activationCondition(buddy -> buddy.isLookingAround).preventionCondition(buddy -> buddy.isSad() || buddy.isSleepy).temporaryState(true).duration(100, 160).build());
    public static final AnimationState STANDING_SAD = AnimationStates.registerState(new AnimationState.Builder("STANDING_SAD", 7).priority(21).allowsMovement(false).allowsHopping(false).activationCondition(buddy -> buddy.isStanding && (buddy.needsFood || buddy.needsPet || buddy.needsPlay && !buddy.isPlaying || buddy.poops.size() >= 3)).preventionCondition(buddy -> buddy.isSleepy || buddy.isOffScreen).temporaryState(true).duration(70, 150).build());
    public static final AnimationState STRETCHING_STANDING = AnimationStates.registerState(new AnimationState.Builder("STRETCHING_STANDING", 8).priority(20).allowsMovement(false).allowsHopping(false).activationCondition(buddy -> buddy.isStretching).preventionCondition(buddy -> buddy.isSleepy).temporaryState(true).duration(50, 60).build());
    public static final AnimationState STANDING = AnimationStates.registerState(new AnimationState.Builder("STANDING", 6).priority(19).allowsMovement(false).activationCondition(buddy -> buddy.isStanding).preventionCondition(buddy -> buddy.isSleepy || buddy.isOffScreen).temporaryState(true).duration(50, 100).build());
    public static final AnimationState WALKING_SAD = AnimationStates.registerState(new AnimationState.Builder("WALKING_SAD", 2).priority(10).allowsHopping(false).walkingSpeed((buddy, state) -> 1).activationCondition(buddy -> buddy.isSad() && !buddy.isPlaying && !buddy.isChasingBall).build());
    public static final AnimationState WALKING_SLEEPY = AnimationStates.registerState(new AnimationState.Builder("WALKING_SLEEPY", 13).priority(9).animationSpeed((buddy, state) -> 25).walkingSpeed((buddy, state) -> 1).allowsHopping(false).activationCondition(buddy -> buddy.isSleepy).build());
    public static final AnimationState WALKING_EXCITED = AnimationStates.registerState(new AnimationState.Builder("WALKING_EXCITED", 9).priority(8).walkingSpeed((buddy, state) -> 4).activationCondition(buddy -> buddy.isExcited).preventionCondition(buddy -> buddy.isSleepy).temporaryState(true).duration(70, 100).build());
    public static final AnimationState RUNNING = AnimationStates.registerState(new AnimationState.Builder("RUNNING", 0).priority(1).animationSpeed((buddy, state) -> 3).walkingSpeed((buddy, state) -> 7).activationCondition(buddy -> buddy.energy >= 50.0f && buddy.chanceCheck(0.02f)).preventionCondition(buddy -> buddy.isSad() || buddy.isSleepy).temporaryState(true).duration(30, 50).lockStateUntilFinished(true).cooldown(60000L).build());
    public static final AnimationState WALKING = AnimationStates.registerState(new AnimationState.Builder("WALKING", 0).priority(0).walkingSpeed((buddy, state) -> buddy.energy < 10.0f ? 1 : 2).activationCondition(buddy -> true).preventionCondition(buddy -> buddy.isSleepy).build());
    private static List<AnimationState> cachedSortedStates = null;

    @NotNull
    public static AnimationState registerState(@NotNull AnimationState state) {
        STATE_MAP.put(state.getName(), state);
        cachedSortedStates = null;
        return state;
    }

    @Nullable
    public static AnimationState getStateByName(@NotNull String name) {
        return STATE_MAP.get(name);
    }

    @NotNull
    public static List<AnimationState> getStates() {
        if (cachedSortedStates == null) {
            ArrayList<AnimationState> l = new ArrayList<AnimationState>(STATE_MAP.values());
            l.sort((a, b) -> Integer.compare(b.getPriority(), a.getPriority()));
            cachedSortedStates = l;
        }
        return cachedSortedStates;
    }

    @NotNull
    public static AnimationState findFirstValidStateFor(@NotNull Buddy buddy) {
        AnimationState selectedState = null;
        for (AnimationState state : AnimationStates.getStates()) {
            if (!state.canActivate(buddy)) continue;
            selectedState = state;
            break;
        }
        if (selectedState == null) {
            selectedState = WALKING;
        }
        return selectedState;
    }
}

